#include "SortThread.h"

//---------------------------------------------------------------------------
//Konstruktor
TSortThread::TSortThread(sorttype* OriginalData, int _DataAmount,bool CreateSuspended)
:TThread(CreateSuspended),Data(NULL),OutputListBoxColor(clBtnFace)
{
//Ustawienia TThreat
FreeOnTerminate=true; //Usuwa z pamieci po zakonczeniu Execute

//Rezerwacja pamieci i kopiowanie danych
DataAmount=_DataAmount;
Data=(sorttype *)calloc(DataAmount,sizeof(sorttype));
for (int i=0; i<DataAmount; i++) Data[i]=OriginalData[i];
}

//Destruktor
__fastcall TSortThread::~TSortThread()
{
free(Data);
Data=NULL;
//ShowMessage("Wtek zakoczy dziaanie ("+(AnsiString)SortMethod+")");
}

//---------------------------------------------------------------------------
//Metoda uruchamiajaca sortowanie
#include "quicksort.c"

void __fastcall TSortThread::Execute()
{
if (Data==0 || SortMethod==smNone) return;

//Sortowanie
switch (SortMethod)
	{
    case smBubble: bubblesort(Data,DataAmount); break;
    case smSelection: selectionsort(Data,DataAmount); break;
    case smInsert: insertsort(Data,DataAmount); break;
    case smQuick: quicksort(Data,DataAmount); break;
    }

//Zapisywanie wynikow
OutputListBox->Color=OutputListBoxColor;
OutputListBox->Items->Clear();
for (int i=0; i<DataAmount; i++) OutputListBox->Items->Add(Data[i]);
OutputListBox->Refresh();
}


//---------------------------------------------------------------------------
//ZAIMPORTOWANE FUNKCJE SORTUJACE

//Sortowanie babelkowe
void TSortThread::bubblesort(sorttype* A, int const A_ile)
{
  for (int i=A_ile; i>=0; i--)
    for (int j=0; j<i-1; j++)
      if (A[j]>A[j+1])
      {
      sorttype tmp=A[j];
      A[j]=A[j+1];
      A[j+1]=tmp;
      if (Terminated) Free(); //reakcja na Terminate()
      }
return;
}

//Metoda wyboru
void TSortThread::selectionsort(sorttype* A, int const A_ilel)
{
  for (int i=0; i<A_ilel; i++)
    for (int j=A_ilel-1; j>i; j--)
      if (A[i]>A[j])
      	{
        sorttype tmp=A[i]; A[i]=A[j]; A[j]=tmp;
        if (Terminated) Free(); //reakcja na Terminate()
        }
}

//Sortowanie przez wstawianie
void TSortThread::insertsort(sorttype* A, int const A_ile)
{
  for (int i=0; i<=A_ile-1; i++)
  	{
	sorttype tmp=A[i];
    int j=i;
    while(j>0 && A[j-1]>=tmp)
    	{
        A[j]=A[j-1];
        --j;
        if (Terminated) Free(); //reakcja na Terminate()
        }
    A[j]=tmp;
    }
}


